/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.ThrownShoe;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Boyfriend
extends Girlfriend {
    private Texture prince1texture = null;
    private Texture prince2texture = null;

    public Boyfriend(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.75f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Boyfriend";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(60.0f);
        this.setHealth(60.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(5.5f);
        this.attackRange = 3.5f;
        this.movefrequency = 45;
        this.setExperience(60);
        this.searchDistance = 16.0f;
        this.canSwim = true;
        this.setCanDespawn(false);
        this.maxdisttoowner = 18.0f;
        if (w != null) {
            this.setBID(-1);
            this.setBID(w.rand.nextInt(28));
            this.setIID(w.rand.nextInt(18));
            this.setVarFloat(21, (w.rand.nextFloat() - w.rand.nextFloat()) * 0.15f);
        } else {
            this.setBID(-1);
            this.setBID(DangerZone.rand.nextInt(28));
            this.setIID(DangerZone.rand.nextInt(18));
            this.setVarFloat(21, (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.15f);
        }
        this.drytexture = new Texture[28];
        this.wettexture = new Texture[18];
        this.has_inventory = true;
        this.enable_followfood = true;
        this.isImmuneToFire = true;
        this.foodsearchDistance = 12;
        this.tower_defense_enable = false;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(12) != 1) {
            return null;
        }
        if (this.getStaying()) {
            return null;
        }
        if (this.getQuiet()) {
            return null;
        }
        if (this.getAttacking()) {
            return null;
        }
        if (this.sound_busy > 0) {
            return null;
        }
        if (this.getOwnerName() != null) {
            if (this.posy < 50.0 && this.world.rand.nextInt(3) != 0) {
                return null;
            }
            this.sound_busy = 30;
            if (DangerZone.thundercount > 0 && this.world.rand.nextBoolean()) {
                return "OreSpawn:b_thunder";
            }
            if (this.world.rand.nextInt(4) == 1 && this.isRaining()) {
                if (this.world.rand.nextBoolean()) {
                    return "OreSpawn:b_rain1";
                }
                return "OreSpawn:b_rain2";
            }
            if (this.getHealth() >= this.getMaxHealth()) {
                if (this.getInLiquid()) {
                    int which = this.world.rand.nextInt(2);
                    if (which == 0) {
                        return "OreSpawn:b_water1";
                    }
                    if (which == 1) {
                        return "OreSpawn:b_water2";
                    }
                }
                if (!this.world.isDaytime() && this.world.rand.nextBoolean()) {
                    return "OreSpawn:b_dark";
                }
                return this.getHappySound();
            }
            int which = this.world.rand.nextInt(10);
            if (which == 0) {
                return "OreSpawn:b_hurt1";
            }
            if (which == 1) {
                return "OreSpawn:b_hurt2";
            }
            if (which == 2) {
                return "OreSpawn:b_hurt3";
            }
            if (which == 3) {
                return "OreSpawn:b_hurt4";
            }
            if (which == 4) {
                return "OreSpawn:b_hurt5";
            }
            if (which == 5) {
                return "OreSpawn:b_hurt6";
            }
            if (which == 6) {
                return "OreSpawn:b_hurt7";
            }
            if (which == 7) {
                return "OreSpawn:b_hurt8";
            }
            if (which == 8) {
                return "OreSpawn:b_hurt9";
            }
            if (which == 9) {
                return "OreSpawn:b_hurt10";
            }
        }
        return null;
    }

    public String getHappySound() {
        int which = this.world.rand.nextInt(8);
        if (which == 0) {
            return "OreSpawn:b_happy1";
        }
        if (which == 1) {
            return "OreSpawn:b_happy2";
        }
        if (which == 2) {
            return "OreSpawn:b_happy3";
        }
        if (which == 3) {
            return "OreSpawn:b_happy4";
        }
        if (which == 4) {
            return "OreSpawn:b_happy5";
        }
        if (which == 5) {
            return "OreSpawn:b_happy6";
        }
        if (which == 6) {
            return "OreSpawn:b_happy7";
        }
        if (which == 7) {
            return "OreSpawn:b_happy8";
        }
        return null;
    }

    @Override
    public void onKill(Entity deadthing) {
        int which = this.world.rand.nextInt(4);
        String killsound = null;
        this.sound_busy = 20;
        if (which == 0) {
            killsound = "OreSpawn:b_woohoo1";
        }
        if (which == 1) {
            killsound = "OreSpawn:b_woohoo2";
        }
        if (which == 2) {
            killsound = "OreSpawn:b_woohoo3";
        }
        if (which == 3) {
            killsound = "OreSpawn:b_woohoo4";
        }
        if (killsound != null) {
            this.world.playSound(killsound, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        }
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(9);
        this.sound_busy = 20;
        if (which == 0) {
            return "OreSpawn:b_ow1";
        }
        if (which == 1) {
            return "OreSpawn:b_ow2";
        }
        if (which == 2) {
            return "OreSpawn:b_ow3";
        }
        if (which == 3) {
            return "OreSpawn:b_ow4";
        }
        if (which == 4) {
            return "OreSpawn:b_ow5";
        }
        if (which == 5) {
            return "OreSpawn:b_ow6";
        }
        if (which == 6) {
            return "OreSpawn:b_ow7";
        }
        if (which == 7) {
            return "OreSpawn:b_ow8";
        }
        if (which == 8) {
            return "OreSpawn:b_ow9";
        }
        return null;
    }

    @Override
    public String getDeathSound() {
        if (this.getOwnerName() != null) {
            return "OreSpawn:b_death_boyfriend";
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:b_death_single1";
        }
        return "OreSpawn:b_death_single2";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyboyfriend.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.getOwnerName() != null) {
            Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        int howmany = this.world.rand.nextInt(5) + 3;
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.gamecontroller.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        this.doDeathDropsNotGirl();
    }

    @Override
    public Texture getTexture() {
        if (this.drytexture[0] == null) {
            this.drytexture[0] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend0.png");
            this.drytexture[1] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend1.png");
            this.drytexture[2] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend2.png");
            this.drytexture[3] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend3.png");
            this.drytexture[4] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend4.png");
            this.drytexture[5] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend5.png");
            this.drytexture[6] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend6.png");
            this.drytexture[7] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend7.png");
            this.drytexture[8] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend8.png");
            this.drytexture[9] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend9.png");
            this.drytexture[10] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend10.png");
            this.drytexture[11] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend11.png");
            this.drytexture[12] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend12.png");
            this.drytexture[13] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend13.png");
            this.drytexture[14] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend14.png");
            this.drytexture[15] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend15.png");
            this.drytexture[16] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend16.png");
            this.drytexture[17] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend17.png");
            this.drytexture[18] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend18.png");
            this.drytexture[19] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend19.png");
            this.drytexture[20] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend20.png");
            this.drytexture[21] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend21.png");
            this.drytexture[22] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend22.png");
            this.drytexture[23] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend23.png");
            this.drytexture[24] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend24.png");
            this.drytexture[25] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend25.png");
            this.drytexture[26] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend26.png");
            this.drytexture[27] = TextureMapper.getTexture((String)"orespawnres/skins/boyfriend27.png");
            this.wettexture[0] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts0.png");
            this.wettexture[1] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts1.png");
            this.wettexture[2] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts2.png");
            this.wettexture[3] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts3.png");
            this.wettexture[4] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts4.png");
            this.wettexture[5] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts5.png");
            this.wettexture[6] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts6.png");
            this.wettexture[7] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts7.png");
            this.wettexture[8] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts8.png");
            this.wettexture[9] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts9.png");
            this.wettexture[10] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts10.png");
            this.wettexture[11] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts11.png");
            this.wettexture[12] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts12.png");
            this.wettexture[13] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts13.png");
            this.wettexture[14] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts14.png");
            this.wettexture[15] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts15.png");
            this.wettexture[16] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts16.png");
            this.wettexture[17] = TextureMapper.getTexture((String)"orespawnres/skins/swimshorts17.png");
            this.prince1texture = TextureMapper.getTexture((String)"orespawnres/skins/FrogPrince.png");
            this.prince2texture = TextureMapper.getTexture((String)"orespawnres/skins/FrogPrince2.png");
        }
        if (this.getInLiquid()) {
            return this.wettexture[this.getIID()];
        }
        if (this.getVarInt(21) == 1) {
            return this.prince1texture;
        }
        if (this.getVarInt(21) == 2) {
            return this.prince2texture;
        }
        return this.drytexture[this.getBID()];
    }

    @Override
    public void playAttackSound() {
        if (this.sound_busy != 0) {
            return;
        }
        int which = this.world.rand.nextInt(7);
        String sound = null;
        if (which == 0) {
            sound = "OreSpawn:b_fight1";
        }
        if (which == 1) {
            sound = "OreSpawn:b_fight2";
        }
        if (which == 2) {
            sound = "OreSpawn:b_fight3";
        }
        if (which == 3) {
            sound = "OreSpawn:b_fight4";
        }
        if (which == 4) {
            sound = "OreSpawn:b_fight5";
        }
        if (which == 5) {
            sound = "OreSpawn:b_fight6";
        }
        if (which == 6) {
            sound = "OreSpawn:b_fight7";
        }
        this.world.playSound(sound, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        this.sound_busy = 20;
    }

    @Override
    public void playTauntSound() {
        if (this.sound_busy != 0) {
            return;
        }
        int which = this.world.rand.nextInt(6);
        String sound = null;
        if (which == 0) {
            sound = "OreSpawn:b_taunt1";
        }
        if (which == 1) {
            sound = "OreSpawn:b_taunt2";
        }
        if (which == 2) {
            sound = "OreSpawn:b_taunt3";
        }
        if (which == 3) {
            sound = "OreSpawn:b_taunt4";
        }
        if (which == 4) {
            sound = "OreSpawn:b_taunt5";
        }
        if (which == 5) {
            sound = "OreSpawn:b_taunt6";
        }
        this.world.playSound(sound, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        this.sound_busy = 20;
    }

    @Override
    public void throwShoe() {
        ThrownShoe e = (ThrownShoe)this.world.createEntityByName("OreSpawn:ThrownShoe", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * (this.getWidth() + 1.0f)), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
        if (e != null) {
            e.init();
            e.setBID(0);
            e.setIID(OreSpawnMain.gamecontroller.itemID);
            e.thrower = this;
            e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 4.5f, 0.2f);
            this.world.spawnEntityInWorld((Entity)e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    @Override
    public boolean willWearIt(InventoryContainer ic) {
        if (ic == null) {
            return false;
        }
        if (ic.iid == OreSpawnMain.tigerseyeboots.itemID) {
            return false;
        }
        if (ic.iid == OreSpawnMain.tigerseyehelmet.itemID) {
            return false;
        }
        if (ic.iid == OreSpawnMain.tigerseyechestplate.itemID) {
            return false;
        }
        if (ic.iid == OreSpawnMain.tigerseyeleggings.itemID) {
            return false;
        }
        if (ic.iid == OreSpawnMain.pinkboots.itemID) {
            return false;
        }
        if (ic.iid == OreSpawnMain.pinkhelmet.itemID) {
            return false;
        }
        if (ic.iid == OreSpawnMain.pinkchestplate.itemID) {
            return false;
        }
        return ic.iid != OreSpawnMain.pinkleggings.itemID;
    }
}

